 /* Test FSR
  By Benjamin G. Schultz
  July 2017

  Reads the Force Sensitive Resistor (FSR) using the serial monitor.
  
  The circuit:
  * One FSR pin to Analog 0 (A0)
  * One FSR pin to the 5 volt pin (5V)
  * One 10kOhm resistor attached from A0 to ground (GND)


  See Schultz (2018) for more details, or contact benjamin.g.schultz@gmail.com

  References:
  Schultz, B. G. (2018). The Schultz MIDI benchmarking toolbox for MIDI interfaces, percussion pads, and sound cards. Behav. Res. Meth. Schultz, B.G. (2017). Tap Arduino MIDI Extension: A tool for benchmarking MIDI percussion pads, interfaces, and sound cards.
  Behav. Res. Meth.


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

*/



// these constants won't change:
const int fsr_pin = A0; // the piezo is connected to analog pin 0

// these variables will change:
int fsr_reading = 0;      // variable to store the value read from the sensor pin

void setup() {  
  Serial.begin(9600);       // use the serial port
}

void loop() {
  // read the sensor and store it in the variable fsr_reading:
  fsr_reading = analogRead(fsr_pin);

  Serial.println(fsr_reading);

  delay(10);  // delay to avoid overloading the serial port buffer
}

